using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace FS28BluetoothSlaveModeDemo
{
    public partial class FormUserLog : Form
    {
        public FamComm m_commFam = null;
        private byte m_nErrorCode;
        private byte[] m_Log = null;

        public FormUserLog()
        {
            InitializeComponent();
        }

        private void FormUserLog_Load(object sender, EventArgs e)
        {
            listLog.Columns.Add("Group ID", 100, HorizontalAlignment.Left);
            listLog.Columns.Add("User ID", 100, HorizontalAlignment.Left);
            listLog.Columns.Add("Finger ID", 100, HorizontalAlignment.Left);
            listLog.Columns.Add("Date", 100, HorizontalAlignment.Left);
            listLog.Columns.Add("Time", 100, HorizontalAlignment.Left);
        }

        private void btnGetLog_Click(object sender, EventArgs e)
        {
            if (m_commFam == null)
                return;
            textMessage.Text = "";
            textTotal.Text = "";
            EnableControls(false);
            uint nNumLog = 0;
            m_nErrorCode = m_commFam.FamCheckLog(ref nNumLog);
            if (m_nErrorCode != 0)
            {
                textMessage.Text = m_commFam.ErrorMessage;
                EnableControls(true);
                return;
            }
            textTotal.Text = nNumLog.ToString();
            if (nNumLog == 0)
            {
                textMessage.Text = "User log is empty!";
                EnableControls(true);
                return;
            }
            if (m_Log != null)
                m_Log = null;
            m_Log = new byte[nNumLog * 16 + 10];	// every log has 16 bytes data
            uint nOffset = 0;
            while (nNumLog >= 9600)
            {
                byte[] logTemp = new byte[9600 * 16+10];
                m_nErrorCode = m_commFam.FamGetLog(nOffset, 9599, logTemp);
                if (m_nErrorCode != 0)
                {
                    textMessage.Text = m_commFam.ErrorMessage;
                    logTemp = null;
                    m_Log = null;
                    EnableControls(true);
                    return;
                }
                Array.Copy(logTemp, 0, m_Log, nOffset, 9599 * 16);
                nNumLog -= 9599;
                nOffset += 9599;
            }
            if (nNumLog > 0)
            {
                byte[] logTemp = new byte[nNumLog * 16+10];
                m_nErrorCode = m_commFam.FamGetLog(nOffset, nNumLog, logTemp);
                if (m_nErrorCode != 0)
                {
                    textMessage.Text = m_commFam.ErrorMessage;
                    logTemp = null;
                    m_Log = null;
                    EnableControls(true);
                    return;
                }
                Array.Copy(logTemp, 0, m_Log, nOffset, nNumLog * 16);
            }
            listLog.Items.Clear();
            RetrieveAccessLog(nNumLog * 16, m_Log);
            textMessage.Text = "OK";
            EnableControls(true);
        }

        private bool RetrieveAccessLog(uint nLogLength, byte[] userLog)
        {
            ulong nUID;
	        byte nFID, nGID;
	        int nDateTime;
	        uint nUID_H, nUID_L;
	        byte nYear, nMonth, nDay;
	        byte nHour, nMin, nSec;
	        ushort nDate;
	        uint nIndex = 0;
	        String strDate;
	        String strTime;
	        uint nItem = 0;
            nYear = nMonth = nDay = 0;

	        while( nIndex < nLogLength )				//every log has 16 Bytes
	        {
		        nDateTime = 0;
		        nUID_L = nUID_H = 0;
                nDateTime = userLog[nIndex] + userLog[nIndex+1]*0x100 + userLog[nIndex+2]*0x10000 + userLog[nIndex+3]*0x1000000;              //first 4 byte is the DateTime
                nUID_L = (uint)(userLog[nIndex+4] + userLog[nIndex+5]*0x100 + userLog[nIndex+6]*0x10000 + userLog[nIndex+7]*0x1000000);     //UID 6Bytes
                nUID_H = (uint)(userLog[nIndex+8] + userLog[nIndex+9]*0x100);
		        nFID = userLog[nIndex+10];					//FID 1Byte
		        nGID = userLog[nIndex+11];					//GID 1Byte	// the other 4 bytes is reserved for future use
		        nSec = (byte)(nDateTime & 0x3f);				//first 6bit is second
		        nMin = (byte)( (nDateTime >> 6) & 0x3f );		//second 6bit is minute
		        nHour = (byte)( (nDateTime >> 12) & 0x1f );		//5bit is hour
		        nDate = (ushort)( (nDateTime >> 17) & 0x7fff );	// 17bit is date
		        // retrieve year,month,day from nDate
		        DAY_2_DATE(nDate, ref nYear, ref nMonth, ref nDay);

		        nUID = (ulong)(nUID_L + nUID_H * 0x100000000); 
		        nIndex += 16;
		        //add to list control
		        strDate= String.Format("{0:d2}-{1:d2}-{2:d2}", nDay, nMonth, nYear+2000);
		        strTime= String.Format("{0:d2}:{1:d2}:{2:d2}", nHour, nMin, nSec);
                ListViewItem item = listLog.Items.Insert((int)nItem, nGID.ToString());
                item.SubItems.Add(nUID.ToString());
                item.SubItems.Add(nFID.ToString());
                item.SubItems.Add(strDate);
                item.SubItems.Add(strTime);
                
		        nItem++;
	        }
	        return true;
        }

        private int DAY_2_DATE(ushort val, ref byte year, ref byte month, ref byte day)
        {
	        ushort loc_val=0;

	        year = 05;//2005 year
	        do
	        {
		        if((year%4)!=0)//standart year
			        loc_val = 365;
		        else
			        loc_val = 366;
		        if(loc_val<=val)
		        {
			        val -= loc_val;
			        year++;
		        }
		        else
			        break;
	        } while(true);

	        month=1 ;
	        do
	        {
		        if ( month==4 || month==6 || month==9 || month==11 ) 
		        {
		            loc_val = 30;
		        }
		        else if( month==2 )
		        {
			        if((year%4)!=0)//standard year 
				        loc_val = 28;
			        else
				        loc_val = 29;
		        }
		        else//1,3,5,7,8,10,12
			        loc_val = 31;
		        if(loc_val<=val)
		        {
			        val -= loc_val;
			        month++;
		        }
		        else
			        break;
	        } while(true);

	        day = (byte) val;
	        day++;//from 1....

	        return 0;
        }

        private void btnEraseLog_Click(object sender, EventArgs e)
        {
            if (MessageBox.Show("Are you sure to erase all the user's log?\n", "Erase All User's Log", MessageBoxButtons.YesNo, MessageBoxIcon.Question) == DialogResult.No)
            {
                textMessage.Text = "Cancelled by user!";
                return;
            }
            if (m_commFam == null)
                return;
            EnableControls(false);
            textMessage.Text = "";
            textTotal.Text = "";
            m_nErrorCode = m_commFam.FamEraseLog();
            if (m_nErrorCode != 0)
            {
                textMessage.Text = m_commFam.ErrorMessage;
                EnableControls(true);
                return;
            }
            listLog.Items.Clear();
            m_Log = null;
            textMessage.Text = "The user's log is erased!";
            EnableControls(true);
        }

        private void btnExportLog_Click(object sender, EventArgs e)
        {
            if (m_Log == null)
            {
                textMessage.Text = "There is not user's log for exporting.";
                return;
            }
            EnableControls(false);
            textMessage.Text = "";
            SaveFileDialog dlgSave = new SaveFileDialog();
            dlgSave.Filter = "text file(*.txt)|*.txt";
            if (dlgSave.ShowDialog() == DialogResult.OK)
            {
                using (StreamWriter sw = new StreamWriter(dlgSave.FileName))
                {
                    sw.WriteLine("GroupID\t\tUserID\t\tFingerID\tDate\t\t\tTime");
                    for (int i = 0; i < listLog.Items.Count; i++)
                    {
                        sw.WriteLine("{0:s}\t\t{1:s}\t\t{2:s}\t\t{3:s}\t\t{4:s}", listLog.Items[i].SubItems[0].Text,
                            listLog.Items[i].SubItems[1].Text, listLog.Items[i].SubItems[2].Text,
                            listLog.Items[i].SubItems[3].Text, listLog.Items[i].SubItems[4].Text);
                    }
                }
                textMessage.Text = "User's log is exported!";
             }
             else
                textMessage.Text = "Cancel by user!";
            EnableControls(true);
        }

        private void EnableControls(bool bEnable)
        {
            btnGetLog.Enabled = bEnable;
            btnEraseLog.Enabled = bEnable;
            btnExportLog.Enabled = bEnable;
        }
    }
}